<?php

namespace Ignite\Activity\Models\Grid;

use Ignite\Core\Models\Grid\Formatter;
use Illuminate\Support\HtmlString;

class OfferFormatter extends Formatter
{
    /**
     * The offer actions.
     *
     * @param object $model
     *
     * @return \Illuminate\Support\HtmlString|string
     */
    public function actions($model)
    {
        $actions = [];

        if (auth()->user()->can('activity.offer.update')) {
            $actions[] = [
                'click' => '',
                'class' => '',
                'icon' => 'pencil',
                'label' => 'Edit',
                'text' => 'text-default',
                'type' => 'default',
                'link' => route('admin.offer.edit', [
                    'type' => $model->type->code,
                    'offer' => $model->code
                ])
            ];
        }

        if (auth()->user()->can('activity.offer.view')) {
            $actions[] = [
                'click' => '',
                'class' => '',
                'icon' => 'eye',
                'label' => 'View',
                'text' => 'text-default',
                'type' => 'default',
                'link' => route('admin.offer.show', [
                    'type' => $model->type->code,
                    'offer' => $model->code
                ])
            ];
        }

        return $this->buttons($actions);
    }

    /**
     * The offer sequence.
     *
     * @param object $model
     *
     * @return \Illuminate\Support\HtmlString|string
     */
    public function sequence($model)
    {
        return $model->sequence;
    }

    /**
     * The offer label.
     *
     * @param object $model
     *
     * @return \Illuminate\Support\HtmlString|string
     */
    public function label($model)
    {
        return $model->label;
    }

    /**
     * The type reference.
     *
     * @param object $model
     *
     * @return \Illuminate\Support\HtmlString|string
     */
    public function type($model)
    {
        return $model->type->label;
    }

    /**
     * Does the offer earns points.
     *
     * @param object $model
     *
     * @return \Illuminate\Support\HtmlString|string
     */
    public function isRedeemable($model)
    {
        return $this->formatYesNo($model->is_redeemable);
    }
    /**
     * Format the status column.
     *
     * @param  object $model
     *
     * @return HtmlString
     */
    public function status($model)
    {
        return $model->getStatuses()[$model->status];
    }
}
