<?php

namespace Ignite\Activity\Contracts;

use Ignite\Activity\Entities\Offer;
use Illuminate\Http\Request;

interface TypeStrategyInterface
{
    /**
     * Returns new URL to redirect for ActivityTypeController::index()
     * for this activity type, if not the default.
     *
     * @param  Offer       $offer
     * @param  Request     $request
     * @return string|null $url
     */
    public function activityTypeCreateRedirect(Offer $offer, Request $request): ?string;

    /**
     * Returns new URL to redirect for ActivityTypeController::create()
     * for this activity type, if not the default.
     *
     * @param  Offer       $offer
     * @param  Request     $request
     * @return string|null $url
     */
    public function activityTypeIndexRedirect(Request $request): ?string;

    /**
     * Returns new URL for Offer::url() for this activity type, if not the default.
     *
     * @param  Offer       $offer
     * @return string|null $url
     */
    public function offerUrl(Offer $offer): ?string;
}
