<?php

namespace Ignite\Activity\Tests\Unit\Listeners;

use Ignite\Activity\Listeners\AdminMenu;
use Ignite\Activity\Tests\TestCase;
use Ignite\Core\Events\Menus\AdminMenuPreCompile;
use Ignite\Core\Models\Menu\Item;
use Ignite\Core\Models\Menu\Manager;
use Nwidart\Modules\Facades\Module;
use Mockery;

class AdminMenuTest extends TestCase
{
    /**
     * @test
     */
    public function it_will_not_add_an_admin_menu_item_if_the_module_is_disabled()
    {
        Module::disable('Activity');

        $event = Mockery::mock(AdminMenuPreCompile::class)->shouldReceive('getManager')->andReturn(
            Mockery::mock(Manager::class)->shouldNotReceive('add')->getMock()
        );

        $listener = new AdminMenu();

        $listener->handle($event->getMock());
    }

    /**
     * @ test
     */
    public function it_will_add_an_admin_menu_item_if_the_module_is_enabled()
    {
        Module::enable('Activity');

        $event = Mockery::mock(AdminMenuPreCompile::class)->shouldReceive('getManager')->andReturn(
            Mockery::mock(Manager::class)
                ->shouldReceive('add')
                ->once()
                ->with(Mockery::on(function (Item $item) {
                    $isItem = $item instanceof Item;
                    $hasName = 'Activities' === $item->getLabel();
                    $hasIcon = 'heartbeat' === $item->getIcon();

                    return $isItem && $hasName && $hasIcon && $item->canBeViewed() && $item->hasChildren();
                }))
                ->getMock()
        );

        $listener = new AdminMenu();

        $listener->handle($event->getMock());
    }
}
