<?php

namespace Ignite\Activity\Tests;

use Ignite\Activity\Entities\Activity;
use Ignite\Activity\Entities\Offer;
use Ignite\Activity\Entities\Submission;
use Ignite\Activity\Entities\SubmissionStatus;
use Illuminate\Foundation\Testing\RefreshDatabase;

class SubmissionStatusTest extends TestCase
{
    use RefreshDatabase;

    /**
     * @test
     */
    public function it_can_get_the_label()
    {
        $type = $this->buildActivityType();
        /** @var Offer $offer */
        $offer = factory(Offer::class)->create(['type_id' => $type->getKey()]);
        /** @var Activity $activity */
        $activity = factory(Activity::class)->create(['offer_id' => $offer->getKey()]);
        /** @var Submission $submission */
        $submission = factory(Submission::class)->create(['activity_id' => $activity->getKey()]);
        /** @var SubmissionStatus $state */
        $state = factory(SubmissionStatus::class)->create([
            'submission_id' => $submission->getKey(),
            'label' => 'approved'
        ]);

        $this->assertEquals('approved', $state->label());
    }

    /**
     * @test
     */
    public function it_can_get_the_friendly_label()
    {
        $type = $this->buildActivityType();
        /** @var Offer $offer */
        $offer = factory(Offer::class)->create(['type_id' => $type->getKey()]);
        /** @var Activity $activity */
        $activity = factory(Activity::class)->create(['offer_id' => $offer->getKey()]);
        /** @var Submission $submission */
        $submission = factory(Submission::class)->create(['activity_id' => $activity->getKey()]);
        /** @var SubmissionStatus $state */
        $state = factory(SubmissionStatus::class)->create([
            'submission_id' => $submission->getKey(),
            'label' => 'hot_tip'
        ]);

        $this->assertEquals('Hot Tip', $state->friendlyLabel());
    }

    /**
     * @test
     */
    public function it_can_get_the_notes()
    {
        $type = $this->buildActivityType();
        /** @var Offer $offer */
        $offer = factory(Offer::class)->create(['type_id' => $type->getKey()]);
        /** @var Activity $activity */
        $activity = factory(Activity::class)->create(['offer_id' => $offer->getKey()]);
        /** @var Submission $submission */
        $submission = factory(Submission::class)->create(['activity_id' => $activity->getKey()]);
        /** @var SubmissionStatus $state */
        $state = factory(SubmissionStatus::class)->create([
            'submission_id' => $submission->getKey(),
            'notes' => 'Declined due to insufficient information.'
        ]);

        $this->assertEquals('Declined due to insufficient information.', $state->notes());
    }

    /**
     * @test
     */
    public function it_defines_a_relationship_to_the_submission()
    {
        $type = $this->buildActivityType();
        /** @var Offer $offer */
        $offer = factory(Offer::class)->create(['type_id' => $type->getKey()]);
        /** @var Activity $activity */
        $activity = factory(Activity::class)->create(['offer_id' => $offer->getKey()]);
        /** @var Submission $submission */
        $submission = factory(Submission::class)->create(['activity_id' => $activity->getKey()]);
        /** @var SubmissionStatus $state */
        $state = factory(SubmissionStatus::class)->create([
            'submission_id' => $submission->getKey(),
            'label' => 'approved'
        ]);

        $this->assertInstanceOf(Submission::class, $state->submission);
        $this->assertTrue($state->submission->is($submission));
    }

    /**
     * @test
     */
    public function it_defines_a_belongs_to_relationship_to_the_activity_model_through_the_submission()
    {
        $type = $this->buildActivityType();
        /** @var Offer $offer */
        $offer = factory(Offer::class)->create(['type_id' => $type->getKey()]);
        /** @var Activity $activity */
        $activity = factory(Activity::class)->create(['offer_id' => $offer->getKey()]);
        /** @var Submission $submission */
        $submission = factory(Submission::class)->create(['activity_id' => $activity->getKey()]);
        /** @var SubmissionStatus $state */
        $state = factory(SubmissionStatus::class)->create([
            'submission_id' => $submission->getKey(),
        ]);

        $this->assertInstanceOf(Activity::class, $state->activity);
        $this->assertTrue($state->activity->is($activity));
    }
}
