<?php

namespace Ignite\Activity\Providers;

use Ignite\Activity\Console\MakeRuleCommand;
use Ignite\Activity\Console\MakeSchemaCommand;
use Illuminate\Support\ServiceProvider;
use Ignite\Activity\Console\MakeActivityCommand;

class ConsoleServiceProvider extends ServiceProvider
{
    protected $defer = false;

    /**
     * The available commands
     *
     * @var array
     */
    protected $commands = [
        MakeActivityCommand::class,
        MakeRuleCommand::class,
        MakeSchemaCommand::class,
    ];

    /**
     * Register the commands.
     */
    public function register()
    {
        $this->commands($this->commands);
    }

    /**
     * The classes the provider provides.
     *
     * @return array
     */
    public function provides()
    {
        return $this->commands;
    }
}
