<?php

namespace Ignite\Activity\Http\Controllers\Admin;

use Ignite\Activity\Domain\Rules\RuleProcessor;
use Ignite\Activity\Entities\Activity;
use Ignite\Activity\Entities\Offer;
use Ignite\Activity\Entities\RuleLog;
use Ignite\Activity\Entities\Submission;
use Ignite\Activity\Entities\Type;
use Ignite\Core\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Throwable;

class SubmissionRulesController extends Controller
{
    /**
     * @var RuleProcessor
     */
    protected RuleProcessor $processor;

    /**
     * SubmissionRulesController constructor.
     *
     * @param RuleProcessor $processor
     */
    public function __construct(RuleProcessor $processor)
    {
        $this->processor = $processor;
    }

    /**
     * Process the rules in a dry-run.
     *
     * @param Type $type
     * @param Offer $offer
     * @param Activity $activity
     * @param Submission $submission
     * @param Request $request
     *
     * @return JsonResponse
     * @throws Throwable
     */
    public function __invoke(Type $type, Offer $offer, Activity $activity, Submission $submission, Request $request)
    {
        $activity->data->fill($request->except('_token'));

        $manager = $this->processor->setDryRun(true)->process($activity, $submission);

        return response()->json([
            'status' => 'success',
            'changes_value' => $manager->hasChangedValue(),
            'changed_value' => $manager->isChangedValue(),
            'value' => $manager->value(),
            'log' => view('Activity::admin.submissions.partials.rule-log', [
                'offer' => $offer,
                'ruleLog' => new RuleLog(array_merge(['created_at' => now()], $manager->getLog()))
            ])->render(),
            'data' => request()->all()
        ]);
    }
}
