<?php

namespace Ignite\Activity\Http\Controllers\Admin;

use Ignite\Activity\Entities\Activity;
use Ignite\Activity\Entities\Offer;
use Ignite\Activity\Entities\Submission;
use Ignite\Activity\Entities\Type;
use Ignite\Activity\Http\Forms\SubmissionNotesForm;
use Ignite\Core\Http\Controllers\Controller;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Kris\LaravelFormBuilder\FormBuilderTrait;

class SubmissionNotesController extends Controller
{
    use FormBuilderTrait;

    /**
     * Update the notes value.
     *
     * @param Type $type
     * @param Offer $offer
     * @param Activity $activity
     * @param Submission $submission
     * @param Request $request
     *
     * @return Renderable|RedirectResponse
     */
    public function __invoke(Type $type, Offer $offer, Activity $activity, Submission $submission, Request $request)
    {
        $form = $this->form(SubmissionNotesForm::class);

        $form->redirectIfNotValid();

        // TODO: Use the repository!?!

        $submission->update($form->getFieldValues());

        $this->flashSuccess('Notes have been updated successfully.');

        return redirect()->to($submission->present()->editUrl('notes'));
    }
}
