<?php

namespace Ignite\Activity\Http\Controllers\Admin;

use Exception;
use Ignite\Activity\Entities\Offer;
use Ignite\Activity\Entities\Type;
use Ignite\Activity\Http\Forms\OfferForm;
use Ignite\Activity\Models\Grid\ActivityNotificationTable;
use Ignite\Core\Http\Controllers\Controller;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Kris\LaravelFormBuilder\FormBuilderTrait;

class NotificationController extends Controller
{
    use FormBuilderTrait;

    /**
     * Show the list of all activity submissions for the type and offer.
     *
     * @param Type $type
     * @param ActivityNotificationTable $table
     * @param Request $request
     *
     * @return Renderable|JsonResponse
     */
    public function index(Type $type, ActivityNotificationTable $table, Request $request)
    {
        $status = $request->get('status', null);
        $table->with('type', $type);
        $table->with('status', $status);

        if ($request->wantsJson()) {
            return $table->ajax();
        }

        return $table->render('Activity::admin.notification.index', compact('type', 'status'));
    }
    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('Activity::admin.notification.show');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Type $type
     * @param Offer $offer
     *
     * @return Renderable
     */
    public function edit(Type $type, Offer $offer)
    {
        //        $form = $this->form(OfferForm::class, [
        //            'method' => 'POST',
        //            'url' => route('admin.offer.update', compact('type', 'offer')),
        //            'model' => $offer
        //        ]);
        //
        //        return view('Activity::admin.notification.edit', compact('type', 'offer', 'form'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param Type $type
     * @param Offer $offer
     *
     * @return Renderable|\Illuminate\Http\RedirectResponse
     */
    public function update(Type $type, Offer $offer)
    {
        //
    }
}
