<?php

namespace Ignite\Activity\Http\Controllers\Admin;

use Ignite\Activity\Entities\Type;
use Ignite\Activity\Models\Grid\ActivitySubmissionTable;
use Ignite\Core\Http\Controllers\Controller;
use Ignite\Flash\Facades\Flash;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

class ActivityTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @param Type $type
     *
     * @return Renderable|RedirectResponse|JsonResponse
     */
    public function index(Type $type)
    {
        if (! $type->getFirstOffer()) {
            Flash::error("No offers have been configured for {$type->code}.");
            return redirect()->route('admin.dashboard.index');
        }

        return redirect()->route('admin.activity.index', [
            'type' => $type,
            'offer' => $type->getFirstOffer()
        ]);
    }
}
