<?php

namespace Ignite\Activity\Generators;

class RuleGenerator extends Generator
{
    /**
     * @inheritdoc
     */
    public function generate(string $path, array $vars = [])
    {
        $stub = __DIR__ . '/Stubs/Rule.php.stub';

        $this->guardAgainstMissingPlaceholder($vars, 'namespace');
        $this->guardAgainstMissingPlaceholder($vars, 'class');

        $contents = $this->interpolate($this->stub($stub), $vars);

        return $this->store($path, $contents);
    }
}
