<?php

namespace Ignite\Activity\Domain\Schema;

use Exception;
use Throwable;

class SchemaParseException extends Exception
{
    /**
     * @var string
     */
    protected $file;

    /**
     * @var string
     */
    protected $error;

    /**
     * SchemaNotFoundException constructor.
     *
     * @param string $file
     * @param string $error
     * @param int $code
     * @param Throwable|null $previous
     * @throws Exception
     */
    public function __construct($file, $error, $code = 0, Throwable $previous = null)
    {
        $this->file = $file;
        $this->error = $error;

        parent::__construct("Unable to load schema for `{$file}`. Error: {$error}", $code, $previous);
    }

    /**
     * The parsed file that failed.
     *
     * @return string
     */
    public function file()
    {
        return $this->file;
    }

    /**
     * The error during parsing.
     *
     * @return string
     */
    public function error()
    {
        return $this->error;
    }
}
