<?php

namespace Ignite\Activity\Database\Seeders;

use Ignite\Core\Database\Seeders\AbstractSeeder;
use Ignite\Core\Entities\Group;
use Ignite\Core\Entities\Permission;

class ActivityGroupPermissionTableSeeder extends AbstractSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        $path = $this->getFilepath('activity_group_permission.json');
        if (!$path) {
            // if not in config('core.seeder.path folder'), then use default
            $this->path = __DIR__ . '/../../../database/data/';
        }

        $strategy = $this->strategy('json', ['filepath' => $this->getFilepath('activity_group_permission.json')]);

        /** @var \Illuminate\Support\Collection $sources */
        $sources = $strategy->run();

        $permissions = Permission::whereIn('key', $sources->pluck('permission_key')->toArray())->get()->keyBy('key');

        if ($permissions->isEmpty()) {
            echo 'No permissions were seeded.';
            return;
        }

        foreach ($sources as $source) {
            try {
                /** @var Group $group */
                $groups = Group::whereIn('key', explode('|', $source['group_name']))->get();
                $permission = $permissions[$source['permission_key']];
                foreach ($groups as $group) {
                    $hasPermission = $group->hasPermission($permission);
                    $isDeleting = $source['_delete_'] ?? false;

                    if (!$hasPermission && true != $isDeleting) {
                        // dump("Giving {$permission->key} to {$group->name}");
                        $group->givePermissionTo($permission);
                    } elseif ($hasPermission && true == $isDeleting) {
                        // dump("Removing {$permission->key} from {$group->name}");
                        $group->removePermissionFrom($permission);
                    } elseif ($hasPermission) {
                        // dump("Already has permission {$permission->key} for {$group->name}");
                    }
                }
            } catch (\Exception $e) {
                echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
