<?php

namespace Ignite\Activity\Console;

use Ignite\Activity\Generators\RuleGenerator;
use Illuminate\Console\Command;
use Illuminate\Support\Str;
use Nwidart\Modules\Facades\Module;

class MakeRuleCommand extends Command
{
    /**
     * @var string
     */
    public $signature = 'ignite:activity:make-rule
        {name : The name of the rule class.}
        {module : The name of module will be used.}';

    /**
     * @var string
     */
    public $description = 'Create a new activity rule.';

    /**
     * Handle the command behaviour.
     *
     * @param RuleGenerator $ruleGenerator
     */
    public function handle(RuleGenerator $ruleGenerator)
    {
        $ruleName = Str::studly($this->argument('name'));
        $moduleName = $this->argument('module');

        /** @var \Nwidart\Modules\Module $module */
        $module = Module::find($moduleName);

        $autoload = $module->getComposerAttr('autoload')['psr-4'];

        $namespaces = array_keys($autoload);
        $namespace = array_shift($namespaces);

        $paths = array_values($autoload);
        $path = array_shift($paths);

        $target = Str::finish("{$module->getPath()}/{$path}", '/') ."Domain/Rules/{$ruleName}.php";

        $ruleGenerator->generate($target, [
            'namespace' => "{$namespace}Domain\Rules",
            'class' => "{$ruleName}"
        ]);

        $this->info("Generating activity rule {$ruleName} in {$module}.");
    }
}
