@extends('Activity::layouts.master', ['code' => $type->code, 'label' => $type->plural()])

@section('page_heading', $title = "{$activity->offer->label} Submissions")
@section('page_breadcrumb', $title)

@php
    $states = $type->getSchema()->states();
@endphp

@section('page_content')
    <div class="row">
        <div class="col-sm-8">
            @include('Activity::admin.submissions.partials.alert', compact('type', 'submission'))
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    <li role="presentation" class="{{ ! request()->query('section') || 'details' === request()->query('section') ? 'active exact-active' : '' }}">
                        <a href="#submission-details" aria-controls="submission-details" data-toggle="tab"><span>{{ __('Details') }}</span></a>
                    </li>
                    <li role="presentation" class="{{ 'notes' === request()->query('section') ? 'active exact-active' : '' }}">
                        <a href="#submission-notes" aria-controls="submission-notes" data-toggle="tab"><span>{{ __('Notes') }}</span></a>
                    </li>
                    <li role="presentation" class="{{ 'value' === request()->query('section') ? 'active exact-active' : '' }}">
                        <a href="#submission-value" aria-controls="submission-value" data-toggle="tab"><span>{{ __('Value') }}</span></a>
                    </li>
                    <li role="presentation" class="{{ 'status' === request()->query('section') ? 'active exact-active' : '' }}">
                        <a href="#submission-status" aria-controls="submission-status" data-toggle="tab"><span>{{ __('Status') }}</span></a>
                    </li>
                    <li role="presentation" class="{{ 'history' === request()->query('section') ? 'active exact-active' : '' }}">
                        <a href="#submission-history" aria-controls="submission-history" data-toggle="tab"><span>{{ __('History') }}</span></a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div role="tabpanel" id="submission-details" class="tab-pane {{ ! request()->query('section') || 'details' === request()->query('section') ? 'active' : '' }}">
                        @include('Activity::admin.submissions.partials.form', compact('type', 'submission'))
                    </div>
                    <div role="tabpanel" id="submission-notes" class="tab-pane {{ 'notes' === request()->query('section') ? 'active' : '' }}">
                        @include('Activity::admin.submissions.partials.notes', compact('type', 'submission'))
                    </div>
                    <div role="tabpanel" id="submission-value" class="tab-pane {{ 'value' === request()->query('section') ? 'active' : '' }}">
                        @include('Activity::admin.submissions.partials.value', compact('type', 'submission'))
                    </div>
                    <div role="tabpanel" id="submission-status" class="tab-pane {{ 'status' === request()->query('section') ? 'active' : '' }}">
                        <div class="form-group">
                            <label for="submission-status" class="control-label">Current Status: {{ $submission->state->friendlyLabel() }}</label>
                        </div>
                        @if ($type->can('change-status'))
                            @include('Activity::admin.submissions.partials.transitions', compact('type', 'states', 'submission'))
                        @endif
                        @include('Activity::admin.submissions.partials.timeline', compact('type', 'states', 'submission'))
                    </div>
                    <div role="tabpanel" id="submission-history" class="tab-pane {{ 'history' === request()->query('section') ? 'active' : '' }}">
                        @include('Activity::admin.submissions.partials.history', compact('type', 'submission'))
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    <li class="active exact-active">
                        <a href="#submission-meta" aria-controls="submission-meta" data-toggle="tab">
                            <span>{{ __('Meta') }}</span>
                        </a>
                    </li>
                    <li class="">
                        <a href="#submission-participant" aria-controls="submission-meta" data-toggle="tab">
                            <span>{{ __('Participant') }}</span>
                        </a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div role="tabpanel" id="submission-meta" class="tab-pane active">
                        @include('Activity::admin.submissions.partials.meta')
                    </div>
                    <div role="tabpanel" id="submission-participant" class="tab-pane">
                        @include('Activity::admin.submissions.partials.participant', compact('type', 'submission'))
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('js')
    <script>
        $(document).ready(function () {
            $('select#change-status-to').change(function () {
                if ($(this).val() === "") {
                    $("#change-status-btn").attr("disabled", "disabled");
                } else {
                    $("#change-status-btn").removeAttr("disabled");
                }
            });
        });
    </script>
@endpush
