@extends('Activity::layouts.master', ['code' => $type->code, 'label' => $type->plural()])

@section('page_heading', $title = "{$offer->label}")
@section('page_breadcrumb', $title)

@section('page_content')
    <div class="row">
        <div class="col-md-8">
            <div class="box box-primary">
                <div class="box-header with-border" style="background-color: #fafafa">
                    <h3 class="box-title">Offer Details</h3>
                </div>
                {!! form_start($form, ['class' => 'form-horizontal']) !!}
                <div class="box-body">
                    {!! form_until($form, 'is_redeemable') !!}
                </div>
                <div class="box-footer">
                    {!! form_until($form, 'sequence') !!}
                </div>
                <div class="box-footer no-padding">
                    <div class="nav-tabs-custom no-margin">
                        <ul class="nav nav-tabs">
                            @foreach (['en' => 'English', 'es' => 'Spanish'] as $code => $language)
                            <li class="{{ $loop->first ? 'active' : '' }}"><a href="#tab-{{ $code }}" data-toggle="tab" aria-expanded="{{ $loop->first ? 'true' : 'false' }}">{{ $language }}</a></li>
                            @endforeach
                        </ul>
                        <div class="tab-content">
                            {!! form_until($form, 'type_id') !!}
                        </div>
                    </div>
                </div>
                <div class="box-footer">
                    {!! form_rest($form) !!}
                </div>
                {!! form_end($form, false) !!}
            </div>
        </div>
        <div class="col-md-4">
            <div class="box box-primary">
                <div class="box-header with-border" style="background-color: #fafafa">
                    <h3 class="box-title">Rules</h3>
                </div>
                <div class="box-body">
                    <div class="box-group" id="accordion">
                        @forelse ($offer->rules as $rule)
                        <div class="panel box box-primary">
                            <div class="box-header no-border">
                                <h4 class="box-title" style="display: block">
                                    <a style="display: block" data-toggle="collapse" data-parent="#accordion" href="#{{ $rule->related_name }}" aria-expanded="false" class="collapsed">
                                        {{ $rule->related_name }}
                                        <span class="caret pull-right" style="position: relative; top: 10px;"></span>
                                    </a>
                                </h4>
                            </div>
                            <div id="{{ $rule->related_name }}" class="panel-collapse collapse" aria-expanded="false" style="height: 0px;">
                                <div class="box-body">
                                    <div class="mb-2"><p>{{ $rule->instance()->description() }}</p></div>
                                    <table class="table table-bordered">
                                        @foreach ($rule->metaExcept('label', 'description') as $key => $value)
                                            <tr>
                                                <th style="padding-right: 8px">{{ $key }}</th>
                                                <td style="padding-right: 8px">{{ $value }}</td>
                                            </tr>
                                        @endforeach
                                    </table>
                                </div>
                            </div>
                        </div>
                        @empty
                            <p class="alert alert-warning">No rules are currently associated with this offer.</p>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
@endsection
