<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class UpdateActivityTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasColumn('activity', 'submitter_id')) {
            Schema::table('activity', function (Blueprint $table) {
                $table->renameColumn('submitter_id', 'submitted_by_user_id');
            });
        } else {
            Schema::table('activity', function (Blueprint $table) {
                $table->unsignedInteger('submitted_by_user_id')->nullable()->after('offer_id');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('activity', function (Blueprint $table) {
            $table->renameColumn('submitted_by_user_id', 'submitter_id');
        });
    }
}
