<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateActivityRuleLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('activity_rule_log', function (Blueprint $table) {
            $table->id();
            $table->foreignId('type_id')->constrained('activity_type')->cascadeOnUpdate();
            $table->foreignId('offer_id')->constrained('activity_offer')->cascadeOnUpdate();
            $table->foreignId('activity_id')->constrained('activity')->cascadeOnUpdate();
            $table->foreignId('submission_id')->constrained('activity_submission')->cascadeOnUpdate();
            $table->json('details')->nullable();
            $table->unsignedBigInteger('value')->nullable()->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('activity_rule_log');
    }
}
