<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateActivityOfferTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('activity_offer', function (Blueprint $table) {
            $table->id();
            $table->foreignId('type_id')->nullable()->constrained('activity_type')->cascadeOnUpdate();
            $table->string('label');
            $table->string('code');
            $table->string('related_name'); // short-name for the fully-qualified class name of the Offer form
            $table->tinyInteger('status')->default(1);
            $table->boolean('is_redeemable')->default(1);
            $table->json('meta')->nullable();
            $table->json('translations')->nullable();
            $table->unsignedBigInteger('sequence')->nullable();
            $table->timestamps();
            $table->unique(['type_id', 'code']);
        });

        DB::statement("ALTER TABLE activity_offer AUTO_INCREMENT = 100");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('activity_offer');
    }
}
