<?php

namespace Ignite\Activity\Entities;

use Ignite\Activity\Domain\Rules\RuleFactory;
use Ignite\Activity\Traits\MetableTrait;
use Ignite\Core\Entities\Base;
use Illuminate\Support\Carbon;

/**
 * Activity Rule Entity
 *
 * @property int $id
 * @property string $related_name
 * @property array $meta
 * @property Offer $offer
 * @property Carbon $created_at
 * @property Carbon $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\Ignite\Activity\Entities\Offer[] $offers
 * @property-read int|null $offers_count
 * @method static \Illuminate\Database\Eloquent\Builder|Rule newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Rule newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Rule query()
 * @method static \Illuminate\Database\Eloquent\Builder|Rule whereCreatedAt($value)
 * @method static Builder|Base whereHasPermission(string $permission, ?\Ignite\Core\Entities\User $user = null)
 * @method static \Illuminate\Database\Eloquent\Builder|Rule whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Rule whereMeta($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Rule whereRelatedName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Rule whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class Rule extends Base
{
    use MetableTrait;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'activity_rule';

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'meta' => 'json',
    ];

    // Getters

    /**
     * The name of the related class of the Rule.
     *
     * @return string
     */
    public function relatedName()
    {
        return $this->related_name;
    }

    /**
     * Get an instance of the Rule class represented by related_name.
     *
     * @param array $params
     *
     * @return \Ignite\Activity\Contracts\Rule
     * @throws \Exception
     */
    public function instance(array $params = [])
    {
        /** @var RuleFactory $ruleMap */
        $ruleMap = app(RuleFactory::class);

        return $ruleMap->make($this->related_name, array_merge(['rule' => $this], $params));
    }

    // Relationships

    /**
     * The relationship to the collection of offer records.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function offers()
    {
        return $this->belongsToMany(Offer::class, 'activity_offer_rule', 'rule_id', 'offer_id');
    }
}
