<?php

return [
    'name' => 'Activity',

    'schema' => [
        'sales' => 'forms/sales.json',
        'certification' => 'forms/certification.json',
    ],

    // dont believe events is being used; and is already events in EventServiceProvider
    'events' => [
        Ignite\Activity\Events\ActivitySubmissionCreated::class => [
            Ignite\Activity\Listeners\ProcessRules::class
        ]
    ],

    'import' => [
        'types' => [
            'activity_status' => [
                'class' => Ignite\Activity\Services\Importers\ActivityStatusImporter::class,
                'label' => 'Activity Status',
                'columns' => ['submission_id', 'user_id', 'status', 'notes']
            ],
        ],
    ],
];
