<?php

namespace Ignite\Activity\Http\Controllers\Admin;

use Exception;
use Ignite\Activity\Contracts\ActivitySubmissionRepository;
use Ignite\Activity\Entities\Activity;
use Ignite\Activity\Entities\Offer;
use Ignite\Activity\Entities\Submission;
use Ignite\Activity\Entities\Type;
use Ignite\Activity\Http\Forms\SubmissionValueForm;
use Ignite\Core\Http\Controllers\Controller;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Kris\LaravelFormBuilder\FormBuilderTrait;

class SubmissionValueController extends Controller
{
    use FormBuilderTrait;

    /**
     * @var ActivitySubmissionRepository
     */
    protected ActivitySubmissionRepository $repository;

    /**
     * SubmissionValueController constructor.
     *
     * @param ActivitySubmissionRepository $repository
     */
    public function __construct(ActivitySubmissionRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Update the activity status value.
     *
     * @param Type $type
     * @param Offer $offer
     * @param Activity $activity
     * @param Submission $submission
     * @param Authenticatable $user
     * @param Request $request
     *
     * @return Renderable|RedirectResponse
     */
    public function __invoke(
        Type $type,
        Offer $offer,
        Activity $activity,
        Submission $submission,
        Authenticatable $user,
        Request $request
    ) {
        $form = $this->form(SubmissionValueForm::class, ['model' => $submission], ['offer' => $offer]);

        $form->redirectIfNotValid();

        try {
            $this->repository->changeValue(
                $submission->getKey(),
                $form->getFieldValues()['value'],
                $user,
                $isManual = true
            );

            $this->flashSuccess('The value has been changed.');
        } catch (Exception $exception) {
            logger()->error($exception->getMessage(), compact('exception'));

            $this->flashError('The value has not been changed.');
        }

        return redirect()->to($submission->present()->editUrl('action'));
    }
}
