<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateActivityTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('activity', function (Blueprint $table) {
            $table->id();
            // we are not using type_id, and it is redundant anyway through the activity_offer table
            // @todo: remove type_id field
            $table->foreignId('type_id')->nullable()->constrained('activity_type')->cascadeOnUpdate();
            $table->foreignId('offer_id')->nullable()->constrained('activity_offer')->cascadeOnUpdate();
            $table->unsignedBigInteger('submitter_id')->nullable();
            $table->json('meta')->nullable();
            $table->timestamps();
        });

        DB::statement("ALTER TABLE activity AUTO_INCREMENT = 1000");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('activity');
    }
}
