<?php

namespace Ignite\Activity\Solutions;

use Spatie\ErrorSolutions\Contracts\Solution;

class SchemaFileNotConfiguredSolution implements Solution
{
    /**
     * @var string
     */
    protected $type;

    /**
     * Set the schema type.
     *
     * @param string $type
     *
     * @return $this
     */
    public function setType($type)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * The solution title should be succinct.
     *
     * @return string
     */
    public function getSolutionTitle(): string
    {
        return 'Schema file is not configured';
    }

    /**
     * The solution description should include as much detail as possible.
     *
     * @return string
     */
    public function getSolutionDescription(): string
    {
        return "We have detected that the schema file for Activity type {$this->type} is not configured. " .
            "Open the Activity module config file and add the schema name and file path.";
    }

    /**
     * Provide documentation links to as many sources as possible.
     *
     * @return array
     */
    public function getDocumentationLinks(): array
    {
        return [
            'Ignite Documentation' => 'https://docs.igniteincentives.io',
        ];
    }
}
