<?php

namespace Ignite\Activity\Domain\Schema;

use Ignite\Activity\Contracts\Schema as SchemaContract;
use Illuminate\Support\Arr;
use Illuminate\Support\Fluent;

class Schema extends Fluent implements SchemaContract
{
    /**
     * The activity type model which will hold the data.
     *
     * @return string
     */
    public function model()
    {
        return $this->get('model');
    }

    /**
     * @inheritdoc
     */
    public function provides($key = '', $default = [])
    {
        $provides = $this->get('provides', $default);

        if (! empty($key)) {
            return Arr::get($provides, $key, $default);
        }

        return $provides;
    }

    /**
     * @inheritdoc
     */
    public function initialStatus()
    {
        return collect($this->states())->filter(function ($state) {
            return $state['type'] === 'initial';
        })->first();
    }

    /**
     * @inheritdoc
     */
    public function statuses()
    {
        return $this->get('statuses', []);
    }

    /**
     * @inheritdoc
     */
    public function states()
    {
        return Arr::get($this->attributes, 'statuses.states');
    }

    /**
     * @inheritdoc
     */
    public function transitions()
    {
        return Arr::get($this->attributes, 'statuses.transitions');
    }

    /**
     * @inheritdoc
     */
    public function fields()
    {
        return $this->get('fields', []);
    }

    /**
     * @inheritdoc
     */
    public function field($name)
    {
        $fields = $this->fields();

        $field = collect($fields)->where('name', '=', $name)->first();

        if (empty($field)) {
            throw new SchemaFieldNotFoundException($name, $fields);
        }

        return $field;
    }
}
