<?php

namespace Ignite\Activity\Tests\Generators;

use Ignite\Activity\Generators\SchemaGenerator;
use Ignite\Activity\Tests\TestCase;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mockery;

class SchemaGeneratorTest extends TestCase
{
    use RefreshDatabase;

    /**
     * @test
     */
    public function it_can_generate_a_schema_with_using_target_path_and_name()
    {
        $target = base_path('tests/stubs/themes/test/forms/foo.json');

        $name = 'Foos';

        $instance = $this->app->make(SchemaGenerator::class);

        $schema = $instance->generate($target, ['name' => $name]);

        $this->assertInstanceOf(SchemaGenerator::class, $instance);

        $this->assertArrayHasKey('model', $schema);
        $this->assertArrayHasKey('provides', $schema);
        $this->assertArrayHasKey('statuses', $schema);
        $this->assertArrayHasKey('fields', $schema);
    }
}
