<?php

namespace Ignite\Activity\Tests\Unit;

use Ignite\Activity\Listeners\AdminMenu;
use Ignite\Activity\Providers\EventServiceProvider;
use Ignite\Core\Events\Menus\AdminMenuPreCompile;
use Ignite\Activity\Tests\TestCase;

class EventServiceProviderTest extends TestCase
{
    /**
     * @test
     */
    public function it_defines_the_admin_menu_listener()
    {
        $provider = new EventServiceProvider($this->app);

        $events = $provider->getEvents();

        $this->assertArrayHasKey(AdminMenuPreCompile::class, $events);

        $this->assertContains(AdminMenu::class, $events[AdminMenuPreCompile::class]);
    }
}
