<?php

namespace Ignite\Activity\Tests;

use Ignite\Activity\Database\Seeders\Seeder;
use Illuminate\Foundation\Testing\RefreshDatabase;

class SeederTest extends TestCase
{
    use RefreshDatabase;

    /**
     * @test
     */
    public function it_can_run_the_seeder_correctly()
    {
        $seeder = $this->app->make(Seeder::class);

        $seeder->run();

        $this->assertDatabaseHas('activity_type', [
            'label' => 'Sales',
            'code' => 'sales',
            'sequence' => 1
        ]);

        $this->assertDatabaseHas('activity_offer', [
            'label' => 'General',
            'code' => 'general',
            'related_name' => 'GeneralSales',
            'status' => 1,
            'is_redeemable' => 1,
            'sequence' => 1,
            //'translations' => "{\"en\": {\"label\": \"Submit Sales\", \"description\": \"Submit your sales and earn cash!!!\"}}"
            //"meta" => "{\"value\": {\"max\": 20000}}",
        ]);

        $this->assertDatabaseHas('activity_rule', [
            'related_name' => 'WithinDateBounds',
            //'meta' => '{"label": "Within Date Bounds", "valid_at": "2020-01-01", "description": "Only accepts submissions inside the configured date boundaries.", "valid_until": "2020-12-31"}'
        ]);

        $this->assertDatabaseHas('activity_offer_rule', [
            'sequence' => 1
        ]);
    }
}
