<?php

namespace Ignite\Activity\Entities;

use Ignite\Core\Entities\Base;
use Ignite\Core\Entities\Participant;
use Ignite\Core\Entities\User;
use Illuminate\Support\Carbon;

/**
 * Activity Entity
 *
 * @property int $id
 * @property int $type_id
 * @property int $offer_id
 * @property int $submitted_by_user_id
 * @property int $activity_id
 * @property int $submission_id
 * @property array $data
 * @property array $offer_data
 * @property array $rule_data
 * @property Type $type
 * @property Offer $offer
 * @property User $user
 * @property Participant $participant
 * @property Activity $activity
 * @property Submission $submission
 * @property Carbon $created_at
 * @property Carbon $updated_at
 * @property int|null $user_id
 * @method static \Illuminate\Database\Eloquent\Builder|Resource newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Resource newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Resource query()
 * @method static \Illuminate\Database\Eloquent\Builder|Resource whereActivityId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Resource whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Resource whereData($value)
 * @method static Builder|Base whereHasPermission(string $permission, ?\Ignite\Core\Entities\User $user = null)
 * @method static \Illuminate\Database\Eloquent\Builder|Resource whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Resource whereOfferData($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Resource whereOfferId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Resource whereRuleData($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Resource whereSubmissionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Resource whereTypeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Resource whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Resource whereUserId($value)
 * @mixin \Eloquent
 */
class Resource extends Base
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'activity_resource';

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'data' => 'json',
        'offer_data' => 'json',
        'rule_data' => 'json',
    ];

    /**
     * The relationship to the offer record.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function type()
    {
        return $this->belongsTo(Type::class, 'type_id', 'id');
    }

    /**
     * The relationship to the offer record.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function offer()
    {
        return $this->belongsTo(Offer::class, 'offer_id', 'id');
    }

    /**
     * The relationship to the submitter's user record.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'user_id');
    }

    /**
     * The relationship to the submitter's user record.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function participant()
    {
        return $this->belongsTo(Participant::class, 'user_id', 'user_id');
    }

    /**
     * The relationship to the activity record.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function activity()
    {
        return $this->belongsTo(Activity::class, 'activity_id', 'id');
    }

    /**
     * The relationship to the submission record.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function submission()
    {
        return $this->belongsTo(Submission::class, 'submission_id', 'id');
    }
}
