<?php

namespace Ignite\Activity\Database\Seeders;

use Ignite\Core\Database\Seeders\AbstractSeeder;
use Ignite\Core\Entities\Permission;

class ActivityPermissionTableSeeder extends AbstractSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        $path = $this->getFilepath('activity_permission.json');
        if (!$path) {
            // if not in config('core.seeder.path folder'), then use default
            $this->path = __DIR__ . '/../../../database/data/';
        }

        app('authorization')->forgetCachedPermissions();

        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath('activity_permission.json')
        ]);

        /** @var \Illuminate\Support\Collection $sources */
        $sources = $strategy->run();

        foreach ($sources as $source) {
            try {
                Permission::updateOrCreate(['key' => $source['key']], $source);
            } catch (\Exception $e) {
                echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
