<?php

namespace Ignite\Activity\Contracts;

use Ignite\Activity\Domain\Schema\SchemaFieldNotFoundException;

interface Schema
{
    /**
     * The activity type model which will hold the data.
     *
     * @return string
     */
    public function model();

    /**
     * The providers to be booted at runtime.
     *
     * @param string $key
     * @param array $default
     *
     * @return array
     */
    public function provides($key = '', $default = []);

    /**
     * The activity initial status.
     *
     * @return array
     */
    public function initialStatus();

    /**
     * The activity statuses.
     *
     * @return array
     */
    public function statuses();

    /**
     * The activity state machine states.
     *
     * @return array
     */
    public function states();

    /**
     * The activity state machine transitions.
     *
     * @return array
     */
    public function transitions();

    /**
     * The activity fields.
     *
     * @return array
     */
    public function fields();

    /**
     * The activity field with the matching name.
     *
     * @param string $name
     *
     * @return array
     * @throws SchemaFieldNotFoundException
     */
    public function field($name);
}
