<?php

namespace Ignite\Activity\Contracts;

use Ignite\Activity\Domain\Rules\RuleManager;

interface Rule
{
    /**
     * The user friendly label to represent the Rule in the UI.
     *
     * @return string
     */
    public function label();

    /**
     * the user friendly description to describe the Rule in the UI.
     *
     * @return string
     */
    public function description();

    /**
     * Apply the Rule logic to the given submission.
     *
     * @param RuleManager $manager
     *
     * @return bool
     */
    public function apply(RuleManager $manager);

    /**
     * Determine whether the Rule has been processed or not.
     *
     * @return bool
     */
    public function processed();

    /**
     * The messages returned after the Rule was processed.
     *
     * @return array
     */
    public function messages();
}
