<?php

namespace Ignite\Activity\Console;

use Ignite\Activity\Generators\SchemaGenerator;
use Illuminate\Console\Command;
use Illuminate\Support\Str;
use Nwidart\Modules\Facades\Module;

class MakeSchemaCommand extends Command
{
    /**
     * @var string
     */
    public $signature = 'ignite:activity:make-schema 
        {name : The name of the activity type.} 
        {path : The path to the schema in the theme.}';

    /**
     * @var string
     */
    public $description = 'Create a new activity type schema.';

    /**
     * Handle the command behaviour.
     *
     * @param SchemaGenerator $schemaGenerator
     */
    public function handle(SchemaGenerator $schemaGenerator)
    {
        $name = Str::studly($this->argument('name'));

        $path = $this->argument('path');

        $schemaGenerator->generate($path, [
            'name' => $name
        ]);

        $this->info("Generating activity type schema file for {$name} in {$path}.");
    }
}
