@extends('Activity::layouts.master', ['code' => $type->code, 'label' => $type->plural()])

@section('page_heading', $title = __(":offer Submissions", ['offer' => $offer->label]))
@section('page_breadcrumb', $title)

@section('page_content')
    <div class="row">
        <div class="col-sm-12">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    <li class="{{ ! request()->query('status') ? 'active exact-active' : '' }}">
                        <a href="{{ url("/admin/activity/{$type->code}/submissions/{$offer->code}") }}">
                            <span>{{ __('All') }}</span>
                        </a>
                    </li>
                    @include('Activity::admin.submissions.partials.statuses', compact('type'))
                </ul>
                <div class="tab-content">
                    {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
                    {{-- @todo: delete-many route needs to be added --}}
                    <form id="blocks-delete-form" action="{{ route('admin.activity.index', ['type' => $type->code, 'offer' => $offer->code ]) }}" method="post">
                        {{ csrf_field() }}
                        {{ method_field('DELETE') }}
                        <input type="hidden" name="ids" value="" id="blocks-delete-field" />
                    </form>
                </div>
            </div>
        </div>
    </div>
    @includeWhen($status, 'Activity::admin.submissions.partials.change-status', [
        'url' => route('admin.activity.status.update-many', [
            'type' => $type->code,
            'offer' => $offer->code
        ]),
        'type' => $type,
        'status' => $status,
    ])
@endsection

@section('js')
    @parent
    {!! $dataTable->scripts() !!}
    @include('Core::partials.datatable')
    <script type="text/javascript">
        $(document).ready(function () {
            var $dataTable = $('#dataTableBuilder');

            var buttons = [];
            @can("activity.submission.all.create")
            buttons.push({
                text: '<span class="fa-solid fa-plus text-success"></span> <span class="text-success">Create</span>',
                action: function (e, dt, node, conf) {
                    e.preventDefault();
                    window.location.href = '{{ route('admin.activity.create', compact('type', 'offer')) }}'
                }
            });
            @endcan

            @can("activity.submission.all.change-status")
            @if (! empty($status) && ($type->getStatuses()['states'][$status]['type'] !== 'final' ?? false))
            buttons.push({
                enabled: false,
                text: '<span class="fa-solid fa-expand"></span> <span>Change Status</span>',
                action: function (e, dt, node, conf) {
                    var selected = dt.column(0).checkboxes.selected();
                    if (selected.length) {
                        $('#submission-status-change-selected').val(
                            selected.map(function(box) { return $(box).val(); }).join(',')
                        );
                        $('#submission-status-change-modal').modal('show');
                    } else {
                        $('#submission-status-change-selected').val('');
                    }
                }
            });
            @endif
            @endcan

            @can("activity.submission.all.delete.many")
            buttons.push({
                enabled: false,
                text: '<span class="fa-solid fa-trash text-danger"></span> <span class="text-danger">Delete</span>',
                action: function (e, dt, node, conf) {
                    // deleting is not actually implemented yet
                    var message = 'Deleting submissions is currently disabled. Please consult IT.';
                    alert(message);
                    return;

                    // var selected = dt.column(0).checkboxes.selected();
                    // var message = 'You are about to permanently delete ' + selected.length + ' record(s). Are you sure you wish to proceed?';
                    // if (confirm(message)) {
                    //     $('#blocks-delete-field').val(selected.map(function(box) { return $(box).val(); }).join(','));
                    //     $('#blocks-delete-form').submit();
                    // }
                }
            });
            @endcan

            $dataTable.customButtons({buttons: buttons});

            @can("activity.{$type->code}.delete")
            $.deleteEntry({
                data: function (button) {
                    return {
                        _token: "{{ csrf_token() }}",
                        id: button.attr('href').split('/').pop()
                    }
                },
                onSuccess: function (button) {
                    button.closest('tr')
                        .animate({'backgroundColor': this.settings.background})
                        .fadeOut(function () {
                            $(this).remove();
                            $dataTable.DataTable().ajax.reload();
                        });
                }
            });
            @endcan

            handleDtClearSelected($dataTable, {{ $checkboxColumn ?? 'null' }});
        });
    </script>
@endsection
