@extends('Activity::layouts.master', ['code' => $type->code, 'label' => $type->plural()])

@section('page_heading', $title = "{$offer->label} Submissions")
@section('page_breadcrumb', $title)

@php
    $states = $type->getSchema()->states();
@endphp

@section('page_content')
    <div class="row">
        <div class="col-sm-8">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    <li role="presentation" class="{{ ! request()->query('section') || 'details' === request()->query('section') ? 'active exact-active' : '' }}">
                        <a href="#submission-details" aria-controls="submission-details" data-toggle="tab"><span>{{ __('Details') }}</span></a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div role="tabpanel" id="submission-details" class="tab-pane {{ ! request()->query('section') || 'details' === request()->query('section') ? 'active' : '' }}">
                        @include('Activity::admin.submissions.partials.form', compact('type'))
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">

        </div>
    </div>
@endsection

@section('js')
    @parent
    <script>
    </script>
@endsection
