<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateActivitySubmissionStatusTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasColumn('activity_submission_status', 'user_id')) {
            Schema::table('activity_submission_status', function (Blueprint $table) {
                if ($userConstraintName = $this->getUserConstraintName()) {
                    $table->dropForeign($userConstraintName);
                }

                $table->renameColumn('user_id', 'changed_by_user_id');
            });
        } else {
            Schema::table('activity_submission_status', function (Blueprint $table) {
                $table->unsignedInteger('changed_by_user_id')->nullable()->after('submission_id');
            });
        }

        Schema::table('activity_submission_status', function (Blueprint $table) {
            $table->foreign('changed_by_user_id')
                ->references('user_id')
                ->on('core_user')
                ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('activity_submission_status', function (Blueprint $table) {
            $table->dropForeign('changed_by_user_id');

            $table->renameColumn('changed_by_user_id', 'user_id');
            $table->foreign('user_id')
                ->references('user_id')
                ->on('core_user')
                ->onUpdate('cascade');
        });
    }

    /**
     * Gives you the name of the foreign key constraint we're using for the user_id field.
     *
     * @return string|null
     */
    protected function getUserConstraintName(): ?string
    {
        return \Illuminate\Support\Facades\DB::table('information_schema.REFERENTIAL_CONSTRAINTS')
            ->where('CONSTRAINT_SCHEMA', config('database.connections.mysql.database'))
            ->where('TABLE_NAME', 'activity_submission_status')
            ->where('UNIQUE_CONSTRAINT_NAME', 'PRIMARY')
            ->value('CONSTRAINT_NAME');
    }
}
