<?php

namespace Ignite\Activity\Database\Factories;

use Ignite\Activity\Entities\Type;
use Ignite\Theme\Factory;
use Illuminate\Support\Str;

class OfferFactory extends Factory
{
    /**
     * Define an Activity Offer's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'type_id' => factory(Type::class),
            'status' => 1,
            'label' => $label = $this->faker->unique()->words(4, true),
            'code' => Str::slug($label, '-'),
            'related_name' => Str::studly($label),
            'is_redeemable' => true,
            'sequence' => $this->faker->unique()->numberBetween(1, 100),
            'meta' => [],
            'translations' => []
        ];
    }
}
