<?php

namespace Ignite\Activity\Events;

use Ignite\Activity\Entities\Activity;
use Ignite\Activity\Entities\Offer;
use Ignite\Activity\Entities\Submission;
use Ignite\Core\Entities\Participant;
use Ignite\Core\Entities\User;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Support\Fluent;

class ActivitySubmissionUpdating
{
    /**
     * @var Activity
     */
    public $activity;

    /**
     * @var Submission
     */
    public $submission;

    /**
     * @var Fluent
     */
    public $data;

    /**
     * @var Participant|User|Authenticatable
     */
    public $submitter;

    /**
     * ActivitySubmissionUpdating constructor.
     *
     * @param Activity $activity
     * @param Submission $submission
     * @param Fluent $data
     * @param User $submitter
     */
    public function __construct(Activity $activity, Submission $submission, Fluent $data, $submitter)
    {
        $this->activity = $activity;
        $this->submission = $submission;
        $this->data = $data;
        $this->submitter = $submitter;
    }
}
