<?php

namespace Ignite\Activity\Http\Forms;

use Ignite\Core\Models\Form\Form;

class SubmissionNotesForm extends Form
{
    /**
     * Build the form fields.
     */
    public function buildForm()
    {
        $readonly = $this->getData('readonly', false);

        $this->setFormOptions([
            'method' => 'POST',
            'class' => 'form-simple clearfix'
        ]);

        $this->add('internal_notes', 'textarea', [
            'attr' => [
                'readonly' => $readonly,
                'disabled' => $readonly,
            ]
        ]);

        if (! $readonly) {
            $this->add('submit', 'submit', [
                'attr' => [
                    'class' => 'btn btn-default pull-right',
                ],
                'label' => "Update",
            ]);
        }
    }
}
