<?php

namespace Ignite\Activity\Entities;

use Ignite\Core\Entities\Base;
use Illuminate\Support\Carbon;

/**
 * Submission Status Entity
 *
 * @property int $id
 * @property int $submission_id
 * @property string $label
 * @property string $notes
 * @property Submission $submission
 * @property Activity $activity
 * @property Carbon $created_at
 * @property Carbon $updated_at
 * @property int|null $changed_by_user_id
 * @method static \Illuminate\Database\Eloquent\Builder|SubmissionStatus newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SubmissionStatus newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SubmissionStatus query()
 * @method static \Illuminate\Database\Eloquent\Builder|SubmissionStatus whereChangedByUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SubmissionStatus whereCreatedAt($value)
 * @method static Builder|Base whereHasPermission(string $permission, ?\Ignite\Core\Entities\User $user = null)
 * @method static \Illuminate\Database\Eloquent\Builder|SubmissionStatus whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SubmissionStatus whereLabel($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SubmissionStatus whereNotes($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SubmissionStatus whereSubmissionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SubmissionStatus whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class SubmissionStatus extends Base
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'activity_submission_status';

    /**
     * The label of the status.
     *
     * @return string
     */
    public function label()
    {
        return $this->label;
    }

    /**
     * The human-readable label of the status.
     *
     * @return string
     */
    public function friendlyLabel()
    {
        return ucwords(str_replace(['_', '-'], ' ', $this->label));
    }

    /**
     * The notes associated with the status.
     *
     * @return string
     */
    public function notes()
    {
        return $this->notes;
    }

    /**
     * The relationship to the submitter's user record.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function submission()
    {
        return $this->belongsTo(Submission::class, 'submission_id', 'id');
    }

    /**
     * The relationship to the offer record.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOneThrough
     */
    public function activity()
    {
        return $this->hasOneThrough(Activity::class, Submission::class, 'id', 'id', 'submission_id', 'activity_id');
    }
}
