@php

$audits = $submission->directAndRelatedAudits();

$grouped = $audits->groupBy(function ($model) {
    return $model->created_at->format('F jS, Y');
}, true);

$events = [
    'created' => ['icon' => 'plus', 'label' => 'created', 'color' => 'green'],
    'updated' => ['icon' => 'rotate-right', 'label' => 'updated', 'color' => 'orange'],
    'deleted' => ['icon' => 'ban', 'label' => 'deleted', 'color' => 'red'],
    'restored' => ['icon' => 'undo', 'label' => 'restored', 'color' => 'teal'],
];

@endphp
<h4 class="card-title">{{ __('Audit Logs') }}</h4>
<p>A condensed history of the activity audit log is provided below, for more in-depth audit logging, please contact IT.</p>
<div class="timeline-container">
    <h4 class="card-title">{{ __('History') }}</h4>
    <hr />
    <ul class="timeline">
        @foreach ($grouped as $date => $logs)
        <li class="time-label">
            <span class="bg-white" style="border: 3px solid #dadada">{{ $date }}</span>
        </li>
        <?php /** @var \Ignite\Core\Entities\Audit $log */ ?>
            @foreach ($logs as $log)
            <li>
                <i class="fa-solid fa-{{ $events[$log->event]['icon'] }} bg-{{ $events[$log->event]['color'] }}"></i>
                <div class="timeline-item">
                    <span class="time"><i class="fa-solid fa-clock"></i> {{ $log->created_at->format('g:ia') }}</span>
                    <h4 class="timeline-header">
                        {{ $log->getReadableEntityName()}} {{ $events[$log->event]['label'] }}
                        by {{ null == $log->user_id ? 'SYSTEM' : $log->user->fullName() }}
                    </h4>
                    <div class="timeline-body">
                        @if (! empty($log->getModified()))
                        <table class="table table-bordered">
                            <tbody>
                                <tr>
                                    <th style="width: 33%">Column</th>
                                    <th style="width: 33%">Old</th>
                                    <th style="width: 33%">New</th>
                                </tr>
                                @foreach ($log->getModified() as $column => $changes)
                                <tr>
                                    <td>{{ $column }}</td>
                                    <td>
                                        @if (isset($changes['old']))
                                        {{ (is_array($changes['old']) ? json_encode($changes['old']) : $changes['old'] ) ?? '' }}
                                        @endif
                                    </td>
                                    <td>
                                        @if (isset($changes['new']))
                                        {{ (is_array($changes['new']) ? json_encode($changes['new']) : $changes['new'] )?? '' }}
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @endif
                    </div>
                </div>
            </li>
            @endforeach
        @endforeach
        @if ($audits->isEmpty())
            <li>
                <i class="fa-solid fa-question"></i>
                <div class="timeline-item">
                    <span class="time"><i class="fa-solid fa-clock"></i> {{ now()->format('g:ia') }}</span>
                    <div class="timeline-body">
                        <p>No audit logs have been created yet.</p>
                    </div>
                </div>
            </li>
        @endif
            <li>
                <i class="fa-solid fa-clock bg-gray"></i>
            </li>
    </ul>
</div>
