<?php

namespace Ignite\Activity\Http\Forms;

use Ignite\Core\Models\Form\Form;

class SubmissionValueForm extends Form
{
    /**
     * Build the form fields.
     */
    public function buildForm()
    {
        $readonly = $this->getData('readonly', false);
        $offer = $this->getData('offer');

        $this->setFormOptions([
            'method' => 'POST',
            'class' => 'form-simple clearfix',
            'x-data' => sprintf(
                '{value_is_manual: %s}',
                $this->model->value_is_manual == 1 ? 'true' : 'false'
            )
        ]);

        $this->add('value', 'number', [
            'label' => __('Current Value: :value', ['value' => $this->model->present()->value()]),
            'label_show' => true,
            'value' => $this->model->value,
            'default_value' => $this->model->value,
            'rules' => [
                'required_if:value_is_manual,1'
            ],
            'attr' => [
                'readonly' => $readonly,
                'disabled' => $readonly,
                'x-ref' => 'state',
                'x-bind:disabled' => 'value_is_manual === false',
                'id' => 'submission-value',
            ]
        ]);

        if (! $readonly) {
            if ($offer->rules->isNotEmpty()) {
                $this->add('value_is_manual', 'checkbox', [
                    'label_show' => true,
                    'label' => __('Would you like to manually override the value?'),
                    'label_attr' => [
                        'style' => 'font-weight:normal; cursor: pointer;'
                    ],
                    'attr' => [
                        'readonly' => $readonly,
                        'disabled' => $readonly,
                        'value' => 1,
                        'checked' => $this->model->value_is_manual,
                        '@change' => 'value_is_manual = ! value_is_manual',
                        'x-bind:checked' => 'value_is_manual',
                    ]
                ]);
            }
        }

        if (! $readonly) {
            $this->add('submit', 'submit', [
                'wrapper' => [
                    'x-show' => 'value_is_manual'
                ],
                'attr' => [
                    'class' => 'btn btn-default pull-right',
                ],
                'label' => __('Update'),
            ]);
        }
    }
}
