<?php

namespace Ignite\Activity\Tests\Feature;

use Ignite\Activity\Domain\Offers\OfferFormFactory;
use Ignite\Activity\Tests\TestCase;
use Ignite\Core\Database\Seeders\CoreDatabaseSeeder;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Kris\LaravelFormBuilder\Form;

class ActivityTypeControllerTest extends TestCase
{
    use RefreshDatabase;

    /**
     * @test
     */
    public function it_can_display_a_specific_type_of_activity()
    {
        $this->seed(CoreDatabaseSeeder::class);

        $type = $this->buildActivityType();

        $offerForm = app(OfferFormFactory::class);
        $offerForm->register($type->offer->related_name, OfferTestFormInstance::class);

        $this->loginAsAdmin();

        $this->withoutExceptionHandling()
            ->followingRedirects()
            ->get(route('admin.activity.type.show', ['type' => $type]))
            ->assertStatus(200)
            ->assertSee("{$type->label} Management");
    }
}

class OfferTestFormInstance extends Form implements \Ignite\Activity\Contracts\OfferForm
{

}