<?php

namespace Ignite\Activity\Http\Forms;

use Ignite\Core\Models\Form\Form;

class OfferLanguageForm extends Form
{
    public function buildForm()
    {
        $this->add($this->language ?? 'en', 'form', [
            'class' => $this->formBuilder->create(OfferTranslationForm::class),
            'formOptions' => [
                'model' => $this->getModel()
            ],
            'data' => [
                'language' => $this->language
            ]
        ]);
    }

    /**
     * Prepare the field data so it remains consistent.
     *
     * @param array $data
     *
     * @return array
     */
    protected function field($data)
    {
        return array_merge_recursive([
            'label_attr' => [
                'class' => 'control-label col-sm-3'
            ],
            'form_horizontal' => true,
        ], $data);
    }
}
