<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateActivitySubmissionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('activity_submission', function (Blueprint $table) {
            $table->id();
            $table->foreignId('activity_id')->constrained('activity')->cascadeOnUpdate();
            $table->unsignedInteger('user_id');
            $table->string('status');
            $table->double('value')->default(0);
            $table->boolean('value_is_manual')->default(0); // checkbox to indicate if the value was manually overridden by the user
            $table->text('internal_notes')->nullable();
            $table->timestamps();

            $table->foreign('user_id')
                ->references('user_id')
                ->on('core_user')
                ->onUpdate('cascade')
                ->onDelete('restrict');
        });

        DB::statement("ALTER TABLE activity_submission AUTO_INCREMENT = 1000");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('activity_submission');
    }
}
