<?php

namespace Ignite\Activity\Models\Grid;

use Ignite\Activity\Entities\Submission;
use Ignite\Core\Models\Grid\Formatter;

class ActivityFormatter extends Formatter
{
    public function actions($model)
    {
        $actions = [];
        $type = $model->activity->type->code;

        if (auth()->user()->can("activity.submission.{$type}.update")
            || auth()->user()->can("activity.submission.all.update")
        ) {
            $actions[] = [
                'click' => '',
                'class' => '',
                'icon' => 'pencil',
                'label' => 'Edit',
                'text' => 'text-default',
                'type' => 'default',
                'link' => route('admin.activity.edit', [
                    'type' => $model->type()->code,
                    'offer' => $model->offer->code,
                    'submission' => $model->getKey(),
                    'activity' => $model->activity->getKey(),
                ])
            ];
        }

        if (auth()->user()->can("activity.submission.{$type}.browse")
            || auth()->user()->can("activity.submission.all.browse")
        ) {
            $actions[] = [
                'click' => '',
                'class' => '',
                'icon' => 'eye',
                'label' => 'View',
                'text' => 'text-default',
                'type' => 'default',
                'link' => route('admin.activity.show', [
                    'type' => $model->type()->code,
                    'offer' => $model->offer->code,
                    'submission' => $model->getKey(),
                    'activity' => $model->activity->getKey(),
                ])
            ];
        }

        if (auth()->user()->can("activity.submission.{$type}.change-status")
            || auth()->user()->can("activity.submission.all.change-status")
        ) {
            $actions[] = [
                'click' => '',
                'class' => '',
                'icon' => 'expand',
                'label' => 'Change Status',
                'text' => 'text-default',
                'type' => 'default',
                'link' => route('admin.activity.edit', [
                    'type' => $model->type()->code,
                    'offer' => $model->offer->code,
                    'submission' => $model->getKey(),
                    'activity' => $model->activity->getKey(),
                    'section' => 'status'
                ])
            ];
        }

        if (auth()->user()->can("activity.submission.{$type}.delete")
            || auth()->user()->can("activity.submission.all.delete")
        ) {
            $actions[] = [
                'click' => '',
                'class' => '',
                'icon' => 'trash',
                'label' => 'Delete',
                'text' => 'text-danger',
                'type' => 'danger',
                'link' => route('admin.activity.delete', [
                    'type' => $model->type()->code,
                    'offer' => $model->offer->code,
                    'submission' => $model->getKey(),
                    'activity' => $model->activity->getKey(),
                ])
            ];
        }

        return $this->buttons($actions);
    }

    /**
     * Format a checkbox for selecting items in the grid.
     *
     * @param  object $model
     *
     * @return \Illuminate\Support\HtmlString
     */
    public function checkbox($model)
    {
        if (! $model) {
            return $this->html('');
        }

        return $this->formatCheckbox($model->getKey());
    }

    /**
     * The submission reference.
     *
     * @param object $model
     *
     * @return \Illuminate\Support\HtmlString
     */
    public function submission($model)
    {
        return $model->getKey();
    }

    /**
     * The participant first name.
     *
     * @param object $model
     *
     * @return \Illuminate\Support\HtmlString
     */
    public function first($model)
    {
        return $model->participant->first;
    }

    /**
     * The participant last name.
     *
     * @param object $model
     *
     * @return \Illuminate\Support\HtmlString
     */
    public function last($model)
    {
        return $model->participant->last;
    }

    /**
     * The participant email.
     *
     * @param object $model
     *
     * @return \Illuminate\Support\HtmlString
     */
    public function email ($model)
    {
        return $model->participant->email;
    }

    /**
     * The user.
     *
     * @param object $model
     * @return mixed
     */
    public function user($model)
    {
        return $model->participant->getKey();
    }

    /**
     * @param object|Submission $model
     * @return \Illuminate\Support\HtmlString|mixed
     */
    public function status($model)
    {
        $status = parent::status($model);

        $config = $model->getStateMachineConfig();

        if (array_key_exists($model->status, $config['states'])) {
            return $this->html(sprintf(
                '<span class="label bg-%s">%s</span>',
                $config['states'][$model->status]['color'],
                $status
            ));
        }

        return $status;
    }
}
