@if (isset($activity) && isset($submission))
    {!! form(
        $offer->form(['model' => $activity->data], ['backend' => true, 'activity' => $activity, 'attr', 'readonly' => isset($readonly) && $readonly]),
        [
            'x-data' => "submission()",
            'x-init' => implode(' ', [
                "value='" . $submission->value . "';",
                "requiresDryRun=" . (($activity->offer->rules->isEmpty() || $submission->value_is_manual === true) ? 'false' : 'true') . ';',
                "url='" . route('admin.activity.submission.rule-check', [
                    'type' => $type->code,
                    'offer' => $offer->code,
                    'activity' => $activity->getKey(),
                    'submission' => $submission->getKey()
                ]) . "';"
            ]),
            'x-on:submit' => 'handleDryRun'
        ]
    ) !!}
@else
{!! form($offer->form([], ['backend' => true, 'activity' => [], 'readonly' => isset($readonly) && $readonly])) !!}
@endif

@if (isset($activity) && isset($submission))
<div id="rule-check-modal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 id="rule-check-message" class="modal-title"></h4>
            </div>
            <div class="modal-body timeline-container no-margin">
                <ul class="timeline" id="rule-check-timeline"></ul>
            </div>
            <div class="modal-footer">
                <button id="rule-check-cancel" type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button id="rule-check-commit" type="button" class="btn btn-primary">Save value change</button>
            </div>
        </div>
    </div>
</div>

@push('js')
<script>
function submission() {
    return {
        url: '',
        value: 0,
        requiresDryRun: false,
        formatValue: function (value) {
            return parseFloat(value).toLocaleString('en-US', {minimumFractionDigits: 2});
        },
        handleDryRun: function (e) {
            if (this.requiresDryRun) {
                e.preventDefault();

                var form = $(e.target);
                var button = form.find('button[type=submit]');
                var buttonLabel = button.text();
                button.attr('disabled', true);
                button.text('Checking rules...');

                $.ajax({
                    url: this.url,
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name=csrf-token]').attr('content')
                    },
                    data: form.serialize()
                }).fail($.proxy(function (jqXHR, textStatus, errorThrown) {
                    button.attr('disabled', false);
                    button.text(buttonLabel);
                    window.Ignite.Core.flash('The rule check dry-run failed. ' + errorThrown, 'error');
                }, this)).done($.proxy(function (data) {
                    button.attr('disabled', false);
                    button.text(buttonLabel);

                    if (data.changed_value) {
                        $('#rule-check-message').html(
                            'Submission value will change from <strong>' + this.formatValue(this.value) + '</strong> to <strong>' + this.formatValue(data.value) + '</strong>.'
                        );
                        $('#rule-check-timeline').empty().html(data.log);
                        $('#rule-check-commit').on('click', function () {
                            $('#rule-check-modal').modal('hide');
                            window.Ignite.Core.flash('The new value will be applied.', 'success');
                            setTimeout(function () {
                                e.target.submit();
                            }, 2000);
                        });
                        $('#rule-check-modal').modal('show');
                    } else {
                        window.Ignite.Core.flash('The rule check dry-run confirmed that the value will not change.', 'success');
                        setTimeout(function () {
                            e.target.submit();
                        }, 2000);
                    }
                }, this));
            }
        }
    }
}
</script>
@endpush
@endif