<?php

namespace Ignite\Activity\Traits;

use ArrayAccess;
use Illuminate\Support\Arr;

trait TranslatableTrait
{
    /**
     * Get the translation for the key or use the default, for the given locale.
     *
     * @param $key
     * @param null $default
     * @param string $locale
     *
     * @return array|ArrayAccess|mixed
     */
    public function translation($key, $default = null, $locale = 'en')
    {
        return Arr::get($this->translations, "{$locale}.{$key}", $default);
    }

    /**
     * Set the value for the key for the given locale.
     *
     * @param string $key
     * @param mixed $value
     * @param string $locale
     *
     * @return $this
     */
    public function translationSet($key, $value, $locale = 'en')
    {
        $translations = (array) $this->translations;
        Arr::set($translations, "{$locale}.{$key}", $value);
        $this->translations = $translations;

        return $this;
    }

    /**
     * Set the value for the key for the given locale and then save to storage.
     *
     * @param string $key
     * @param mixed $value
     * @param string $locale
     *
     * @return bool
     */
    public function translationSave($key, $value, $locale = 'en')
    {
        return $this->translationSet($key, $value, $locale)->save();
    }
}