<?php

namespace Ignite\Activity\Traits;

trait ManagesPropagationTrait
{
    /**
     * @var bool
     */
    protected $propagationStopped = false;

    /**
     * Indicate whether propagation of behaviour should be stopped .
     *
     * @param bool $flag
     *
     * @return $this
     */
    public function stopPropagation($flag = true): self
    {
        $this->propagationStopped = $flag;

        return $this;
    }

    /**
     * Determine whether propagation was stopped.
     *
     * @return bool
     */
    public function isPropagationStopped(): bool
    {
        return $this->propagationStopped;
    }
}