<?php

namespace Ignite\Activity\Entities;

use Ignite\Core\Entities\Base;
use Ignite\Core\Entities\Participant;
use Ignite\Core\Entities\User;
use Illuminate\Support\Carbon;

/**
 * RuleLog Entity
 *
 * @property int $id
 * @property int $type_id
 * @property int $offer_id
 * @property int $activity_id
 * @property int $submission_id
 * @property Type $type
 * @property Offer $offer
 * @property Activity $activity
 * @property Submission $submission
 * @property array $details
 * @property float $value
 * @property Carbon $created_at
 * @property Carbon $updated_at
 */
class RuleLog extends Base
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'activity_rule_log';

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'details' => 'json'
    ];

    /**
     * The value generated by the rule log.
     *
     * @return float
     */
    public function value()
    {
        return $this->value;
    }

    /**
     * The relationship to the offer record.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function offer()
    {
        return $this->belongsTo(Offer::class, 'offer_id', 'id');
    }

    /**
     * The relationship to the offer record.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOneThrough
     */
    public function type()
    {
        return $this->hasOneThrough(Type::class, Offer::class, 'id', 'id', 'offer_id', 'type_id');
    }

    /**
     * The relationship to the activity record.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function activity()
    {
        return $this->hasOne(Activity::class, 'id', 'activity_id');
    }

    /**
     * The relationship to the submission record.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function submission()
    {
        return $this->hasOne(Submission::class, 'id', 'submission_id');
    }
}
