<?php

namespace Ignite\Activity\Domain\Rules;

use Illuminate\Pipeline\Pipeline;
use Illuminate\Support\Collection;

class RuleChannel
{
    /**
     * @var Pipeline
     */
    protected $pipeline;

    /**
     * RuleChannel constructor.
     *
     * @param Pipeline $pipeline
     */
    public function __construct(Pipeline $pipeline)
    {
        $this->pipeline = $pipeline;
    }

    /**
     * Send the Manager instance through each of the rules to build a log and store state changes.
     *
     * @param RuleManager $manager
     * @param array $rules
     *
     * @return RuleManager
     */
    public function pipe(RuleManager $manager, array $rules)
    {
        return $this->pipeline->send($manager)
            ->through($this->getProcessableRules($rules))
            ->via('process')
            ->thenReturn();
    }

    /**
     * The processable rules are identified by implementing the CanBeProcessed.
     *
     * @param array $rules
     *
     * @return array
     */
    public function getProcessableRules(array $rules)
    {
        return $this->rules($rules)->filter(function ($rule) {
            return $rule instanceof CanBeProcessed;
        })->toArray();
    }

    /**
     * The rules as a collection.
     *
     * @param array $rules
     *
     * @return Collection
     */
    protected function rules($rules)
    {
        return new Collection($rules);
    }
}